<?php

/**
 * @package MPesa For WooCommerce
 * @subpackage Plugin Functions
 * @author Mauko Maunde < hi@mauko.co.ke >
 * @since 0.18.01
 */
function wc_mpesa_post_id_by_meta_key_and_value($key, $value) {
    global $wpdb;
    $meta = $wpdb->get_results("SELECT * FROM `" . $wpdb->postmeta . "` WHERE meta_key='" . $key . "' AND meta_value='" . $value . "' order by meta_id DESC limit 1");
    if (is_array($meta) && !empty($meta) && isset($meta[0])) {
        $meta = $meta[0];
    }

    if (is_object($meta)) {
        return $meta->post_id;
    } else {
        return false;
    }
}

add_action('woocommerce_thankyou_mpesa', 'wc_mpesa_add_content_thankyou_mpesa');

function wc_mpesa_add_content_thankyou_mpesa($order_id) {
    $mpesa = get_option('woocommerce_mpesa_settings');
    $idtype = Osen\Mpesa\C2B::$type;
    if (wc_get_order($order_id)) {
        $order = new WC_Order($order_id);
        $total = $order->get_total();
        $reference = $order_id;
    }

    if ($order->get_payment_method() !== 'mpesa') {
        return;
    }

    $type = ($idtype == 4) ? 'Pay Bill' : 'Buy Goods and Services';
    ?>
    <style>
        @keyframes wave {

            0%,
            60%,
            100% {
                transform: initial;
            }

            30% {
                transform: translateY(-15px);
            }
        }

        @keyframes blink {
            0% {
                opacity: .2;
            }

            20% {
                opacity: 1;
            }

            100% {
                opacity: .2;
            }
        }

        .saving span {
            animation: blink 1.4s linear infinite;
            animation-fill-mode: both;
        }

        .saving span:nth-child(2) {
            animation-delay: .2s;
        }

        .saving span:nth-child(3) {
            animation-delay: .4s;
        }
    </style>
    <section class="woocommerce-order-details">
        <input type="hidden" id="current_order" value="<?php echo $order_id; ?>">
        <input type="hidden" id="payment_method" value="<?php echo $order->get_payment_method(); ?>">
        <div class="saving" id="mpesa_receipt"><div class="alert alert-info"> Payment Request Sent to you Phone, Please check to Confirm.... <span>.</span><span>.</span><span>.</span><span>.</span><span>.</span><span>.</span></div></div>
        <button type="submit" class="btn btn-success" name="request_stk" id="request_stk" value="Click to Send Payment Request to Your Phone" data-value="Click to Send Payment Request to Your Phone">Click to Send Payment Request to Your Phone </button>
    </section>

    <?php if (isset($mpesa['enable_c2b']) && $mpesa['enable_c2b'] == 'yes'): ?>
        <section class="woocommerce-order-details" id="missed_stk">

            <h2 class="woocommerce-order-details__title"></h2>
            <div class="alert alert-warning">
                <b><?php _e("STK Push didn't work? Pay Manually Via M-PESA") ?></b><br>
                1. Go to Safaricom SIM Tool Kit, select M-PESA menu, select Lipa na M-PESA.<br/>
                2. Select Pay Bill.<br/>
                <?php if ($idtype == 4): ?>
                    3. Enter Paybill No. : <?php echo $mpesa['shortcode']; ?>.<br/>
                    4. Enter account no as : <?php echo $reference; ?>.<br/>
                <?php else: ?>
                    3. Enter Till Number No. : <?php echo $mpesa['shortcode']; ?>.<br/>
                    4. Enter account : N/A.<br/>
                <?php endif; ?>
                5. Enter amount as : KES <?php echo round($total); ?>.<br/>
                6. Enter your M-PESA PIN and press OK.<br/>
            </div>

        </section>
        <?php
    endif;
}

add_action('init', 'wc_mpesa_rewrite_add_rewrites');

function wc_mpesa_rewrite_add_rewrites() {
    add_rewrite_rule('wcpesa/([^/]*)/?', 'index.php?wcpesa=$matches[1]', 'top');
}

add_filter('query_vars', 'wc_mpesa_rewrite_add_var');

function wc_mpesa_rewrite_add_var($vars) {
    $vars[] = 'wcpesa';
    return $vars;
}

add_action('template_redirect', 'wc_mpesa_process_ipn');

function wc_mpesa_process_ipn() {
    if (get_query_var('wcpesa')) {
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: Application/json");

        $action = get_query_var('wcpesa', 'something_ominous');

        switch ($action) {
            case "validate":
                exit(wp_send_json(Osen\Mpesa\STK::validate()));
                break;

            case "confirm":
                $response = json_decode(file_get_contents('php://input'), true);

                if (!$response || empty($response)) {
                    exit(wp_send_json(['Error' => 'No response data received']));
                }

                $TransactionType = $response['TransactionType'];
                $mpesaReceiptNumber = $response['TransID'];
                $transactionDate = $response['TransTime'];
                $amount = $response['TransAmount'];
                $BusinessShortCode = $response['BusinessShortCode'];
                $BillRefNumber = $response['BillRefNumber'];
                $InvoiceNumber = $response['InvoiceNumber'];
                $OrgAccountBalance = $response['OrgAccountBalance'];
                $ThirdPartyTransID = $response['ThirdPartyTransID'];
                $phone = $response['MSISDN'];
                $FirstName = $response['FirstName'];
                $MiddleName = $response['MiddleName'];
                $LastName = $response['LastName'];

                $post = wc_mpesa_post_id_by_meta_key_and_value('_reference', $BillRefNumber);
                $_receipt = get_post_meta($post, '_receipt', true);
                if ($_receipt != $mpesaReceiptNumber) {
                    if ($post !== false) {
                        wp_update_post(
                                array(
                                    'post_content' => file_get_contents('php://input'), 'ID' => $post
                                )
                        );
                    } else {
                        $post_id = wp_insert_post(
                                array(
                                    'post_title' => 'C2B',
                                    'post_content' => "Response: " . json_encode($response),
                                    'post_status' => 'publish',
                                    'post_type' => 'mpesaipn',
                                    'post_author' => 1,
                                )
                        );

                        update_post_meta($post_id, '_customer', "{$FirstName} {$MiddleName} {$LastName}");
                        update_post_meta($post_id, '_phone', $phone);
                        update_post_meta($post_id, '_amount', $amount);
                        update_post_meta($post_id, '_receipt', $mpesaReceiptNumber);
                        update_post_meta($post_id, '_order_status', 'processing');
                    }

                    $order_id = get_post_meta($post, '_order_id', true);
                    $amount_due = get_post_meta($post, '_amount', true);
                    $before_ipn_paid = get_post_meta($post, '_paid', true);

                    if (wc_get_order($order_id)) {
                        $order = new WC_Order($order_id);
                        $customer = "{$FirstName} {$MiddleName} {$LastName}";
                    } else {
                        $customer = "MPesa Customer";
                    }

                    $after_ipn_paid = round($before_ipn_paid) + round($amount);
                    $ipn_balance = $after_ipn_paid - $amount_due;

                    $email = FALSE;
                    if (wc_get_order($order_id)) {
                        $order = new WC_Order($order_id);

                        if ($ipn_balance == 0) {
                            $order->update_status('processing', __("Full MPesa Payment Received From {$phone}. Receipt Number {$mpesaReceiptNumber}"));
                            $order->payment_complete();
                            update_post_meta($post, '_order_status', 'complete');

                            $headers = 'From: ' . get_bloginfo('name') . ' <' . get_bloginfo('admin_email') . '>' . "\r\n";
                            $email = TRUE;
                        } elseif ($ipn_balance < 0) {
                            $currency = get_woocommerce_currency();
                            $order->update_status('processing', __("{$phone} has overpayed by {$currency} {$ipn_balance}. Receipt Number {$mpesaReceiptNumber}"));
                            $order->payment_complete();
                            update_post_meta($post, '_order_status', 'complete');
                        } else {
                            $order->update_status('pending');
                            $order->add_order_note(__("MPesa Payment from {$phone} Incomplete"));
                            update_post_meta($post, '_order_status', 'on-hold');
                        }
                    }

                    update_post_meta($post, '_paid', $after_ipn_paid);
                    update_post_meta($post, '_amount', $amount_due);
                    update_post_meta($post, '_balance', $ipn_balance);
                    update_post_meta($post, '_phone', $phone);
                    update_post_meta($post, '_customer', $customer);
                    update_post_meta($post, '_order_id', $order_id);
                    update_post_meta($post, '_receipt', $mpesaReceiptNumber);
                    if ($email) {
                        //wp_mail($order["billing_address"], 'Your Mpesa payment', 'We acknowledge receipt of your payment via MPesa of KSh. ' . $amount . ' on ' . $transactionDate . 'with receipt Number ' . $mpesaReceiptNumber . '.', $headers);
                    }
                }
                exit(wp_send_json(Osen\Mpesa\STK::confirm()));
                break;

            case "register":
                Osen\Mpesa\C2B::register(function ($response) {
                    $status = isset($response['ResponseDescription']) ? 'success' : 'fail';
                    if ($status == 'fail') {
                        $message = isset($response['errorMessage']) ? $response['errorMessage'] : 'Could not register M-PESA URLs, try again later.';
                        $state = 'red';
                    } else {
                        $message = isset($response['ResponseDescription']) ? $response['ResponseDescription'] : 'M-PESA URL registered successfully. You will now receive C2B Payment Notifications.';
                        $state = 'green';
                    }

                    exit(
                            wp_redirect(
                                    add_query_arg(
                                            [
                        'mpesa-urls-registered' => $message,
                        'reg-state' => $state
                                            ], wp_get_referer()
                                    )
                            )
                    );
                });

                break;

            case "reconcile":
                $response = json_decode(file_get_contents('php://input'), true);

                if (!isset($response['Body'])) {
                    exit(wp_send_json(['Error' => 'No response data received']));
                }

                $resultCode = $response['Body']['stkCallback']['ResultCode'];
                $resultDesc = $response['Body']['stkCallback']['ResultDesc'];
                $merchantRequestID = $response['Body']['stkCallback']['MerchantRequestID'];
                $checkoutRequestID = $response['Body']['stkCallback']['CheckoutRequestID'];

                $post = wc_mpesa_post_id_by_meta_key_and_value('_request_id', $merchantRequestID);
                $_receipt = get_post_meta($post, '_receipt', true);
                wp_update_post(['post_content' => file_get_contents('php://input'), 'ID' => $post]);

                $order_id = get_post_meta($post, '_order_id', true);
                $amount_due = get_post_meta($post, '_amount', true);
                $before_ipn_paid = get_post_meta($post, '_paid', true);

                if (wc_get_order($order_id)) {
                    $order = new WC_Order($order_id);
                    $first_name = $order->get_billing_first_name();
                    $last_name = $order->get_billing_last_name();
                    $customer = "{$first_name} {$last_name}";
                } else {
                    $customer = "MPesa Customer";
                }

                if (isset($response['Body']['stkCallback']['CallbackMetadata'])) {
                    $amount = $response['Body']['stkCallback']['CallbackMetadata']['Item'][0]['Value'];
                    $mpesaReceiptNumber = $response['Body']['stkCallback']['CallbackMetadata']['Item'][1]['Value'];
                    $balance = $response['Body']['stkCallback']['CallbackMetadata']['Item'][2]['Value'];
                    $transactionDate = $response['Body']['stkCallback']['CallbackMetadata']['Item'][3]['Value'];
                    $phone = $response['Body']['stkCallback']['CallbackMetadata']['Item'][4]['Value'];

                    $after_ipn_paid = round($before_ipn_paid) + round($amount);
                    $ipn_balance = $after_ipn_paid - $amount_due;

                    if ($_receipt != $mpesaReceiptNumber) {
                        if (wc_get_order($order_id)) {
                            $order = new WC_Order($order_id);

                            if ($ipn_balance == 0) {
                                update_post_meta($post, '_order_status', 'complete');
                                update_post_meta($post, '_receipt', $mpesaReceiptNumber);
                                $order->update_status('processing', __("Full MPesa Payment Received From {$phone}. Receipt Number {$mpesaReceiptNumber}"));
                                $order->payment_complete();

                                $headers[] = 'From: ' . get_bloginfo('name') . ' <' . get_bloginfo('admin_email') . '>' . "\r\n";
                                wp_mail($order["billing_address"], 'Your Mpesa payment', 'We acknowledge receipt of your payment via MPesa of KSh. ' . $amount . ' on ' . $transactionDate . '. Receipt number ' . $mpesaReceiptNumber, $headers);
                            } elseif ($ipn_balance < 0) {
                                $currency = get_woocommerce_currency();
                                $order->update_status('processing', __("{$phone} has overpayed by {$currency} {$ipn_balance}. Receipt Number {$mpesaReceiptNumber}"));
                                $order->payment_complete();
                                update_post_meta($post, '_order_status', 'complete');
                                update_post_meta($post, '_receipt', $mpesaReceiptNumber);
                            } else {
                                $order->update_status('pending');
                                $order->add_order_note(__("MPesa Payment from {$phone} Incomplete"));
                                update_post_meta($post, '_order_status', 'on-hold');
                            }
                        }

                        update_post_meta($post, '_paid', $after_ipn_paid);
                        update_post_meta($post, '_amount', $amount_due);
                        update_post_meta($post, '_balance', $ipn_balance);
                        update_post_meta($post, '_phone', $phone);
                        update_post_meta($post, '_customer', $customer);
                        update_post_meta($post, '_order_id', $order_id);
                        update_post_meta($post, '_receipt', $mpesaReceiptNumber);
                    }
                } else {
                    if (wc_get_order($order_id)) {
                        $order = new WC_Order($order_id);
                        //$order->update_status('on-hold');
                        $order->add_order_note(__("MPesa Error {$resultCode}: {$resultDesc}"));
                    }
                }

                exit(wp_send_json(Osen\Mpesa\STK::reconcile()));
                break;

            case "status":
                $transaction = $_POST['transaction'];
                exit(wp_send_json(Osen\Mpesa\STK::status($transaction)));
                break;

            case "result":
                $response = json_decode(file_get_contents('php://input'), true);

                $result = $response['Result'];

                $ResultType = $result['ResultType'];
                $ResultCode = $result['ResultType'];
                $ResultDesc = $result['ResultType'];
                $OriginatorConversationID = $result['ResultType'];
                $ConversationID = $result['ResultType'];
                $TransactionID = $result['ResultType'];
                $ResultParameters = $result['ResultType'];

                $ResultParameter = $result['ResultType'];

                $ReceiptNo = $ResultParameter[0]['Value'];
                $ConversationID = $ResultParameter[0]['Value'];
                $FinalisedTime = $ResultParameter[0]['Value'];
                $Amount = $ResultParameter[0]['Value'];
                $ReceiptNo = $ResultParameter[0]['Value'];
                $TransactionStatus = $ResultParameter[0]['Value'];
                $ReasonType = $ResultParameter[0]['Value'];
                $TransactionReason = $ResultParameter[0]['Value'];
                $DebitPartyCharges = $ResultParameter[0]['Value'];
                $DebitAccountType = $ResultParameter[0]['Value'];
                $InitiatedTime = $ResultParameter[0]['Value'];
                $OriginatorConversationID = $ResultParameter[0]['Value'];
                $CreditPartyName = $ResultParameter[0]['Value'];
                $DebitPartyName = $ResultParameter[0]['Value'];

                $ReferenceData = $result['ReferenceData'];
                $ReferenceItem = $ReferenceData['ReferenceItem'];
                $Occasion = $ReferenceItem[0]['Value'];
                exit(wp_send_json(Osen\Mpesa\STK::validate()));
                break;

            case "timeout":
                $response = json_decode(file_get_contents('php://input'), true);

                if (!isset($response['Body'])) {
                    exit(wp_send_json(['Error' => 'No response data received']));
                }

                $resultCode = $response['Body']['stkCallback']['ResultCode'];
                $resultDesc = $response['Body']['stkCallback']['ResultDesc'];
                $merchantRequestID = $response['Body']['stkCallback']['MerchantRequestID'];
                $checkoutRequestID = $response['Body']['stkCallback']['CheckoutRequestID'];

                $post = wc_mpesa_post_id_by_meta_key_and_value('_request_id', $merchantRequestID);
                wp_update_post(['post_content' => file_get_contents('php://input'), 'ID' => $post]);
                update_post_meta($post, '_order_status', 'pending');

                $order_id = get_post_meta($post, '_order_id', true);
                if (wc_get_order($order_id)) {
                    $order = new WC_Order($order_id);

                    $order->update_status('pending');
                    $order->add_order_note(__("MPesa Payment Timed Out", 'woocommerce'));
                }

                exit(wp_send_json(Osen\Mpesa\STK::timeout()));
                break;
            default:
                exit(wp_send_json(Osen\Mpesa\C2B::register()));
        }
    }

    if (isset($_GET['pesaipn'])) {
        $response = array('receipt' => '');

        if (!empty($_GET['order'])) {
            $post = wc_mpesa_post_id_by_meta_key_and_value('_order_id', $_GET['order']);
            $status = get_post_meta($post, '_order_status', true);
            if ($status == 'on-hold') {
                $CheckoutRequestID = get_post_meta($post, '_checkout_request_id', true);
                $result = Osen\Mpesa\STK::stkStatusQuery($CheckoutRequestID);
                //echo json_encode($result);
                if (isset($result['ResultCode'])) {
                    // Update the local persisted checkouts ResultCode
                    $resultCode = intval($result['ResultCode']);
                    switch ($resultCode) {
                        case 0:
                        case 1001:
                            $response = Array('receipt' => '',
                                'description' => 'You have an active payment session. Please wait',
                                'description_type' => 'warning',
                                'status' => 'FAULTY'
                            );
                            break;
                        case 1032:
                        case 1037:
                        case 1036:
                        default:
                            // Timed out before a payment was received
                            $response = Array('receipt' => '',
                                'description' => "We are having an issue sending payment request to your phone. Please try again by clicking the button below or follow the instructions below to make a payment manualy.",
                                'description_type' => 'warning',
                                'status' => 'CANCELLED'
                            );
                    }
                } else if (isset($result['errorCode'])) {
                    $response = Array('receipt' => '',
                        'description' => "You have an active payment session. Please wait.",
                        'description_type' => 'warning',
                        'status' => 'FAULTY'
                    );
                }
            } else if ($status == 'failed') {
                $response = array(
                    'receipt' => '',
                    'description' => "We are having an issue sending payment request to your phone. Please try again by clicking the button below or follow the instructions below to make a payment manualy.",
                    'description_type' => 'warning',
                    'status' => 'CANCELLED'
                );
            } else {
                $response = array(
                    'receipt' => get_post_meta($post, '_receipt', true),
                    'description' => '',
                    'description_type' => 'warning',
                    'status' => 'FAULTY'
                );
            }
        }

        exit(wp_send_json($response));
    } else if (isset($_GET['pesaipn_stk'])) {
        $response = array("status" => "", "msg" => "");
        $order_id = $_GET['order'];
        $post = wc_mpesa_post_id_by_meta_key_and_value('_order_id', $order_id);
        $order = new WC_Order($order_id);

        $total = $order->get_total();
        $phone = $order->get_billing_phone();
        $result = Osen\Mpesa\STK::request($phone, $total, $order_id, "WooCommerce Payment", 'WCMPesa');
	//die(json_decode($result));
        if ($result) {
            $request_id = $result['MerchantRequestID'];

            if (isset($result['errorCode'])) {
                $error_message = 'MPesa Error ' . $result['errorCode'] . ': ' . $result['errorMessage'];
                //$order->update_status('failed', __($error_message, 'woocommerce'));
                update_post_meta($post, '_order_status', 'failed');
                $response = array("status" => 1, "msg" => $error_message);
            } else {
                /**
                 * Temporarily set status as "on-hold", incase the MPesa API times out before processing our request
                 */
                //$order->update_status('on-hold', __('Awaiting MPesa confirmation of payment from ' . $phone . '.', 'woocommerce'));

                update_post_meta($post, '_request_id', $result['MerchantRequestID']);
                update_post_meta($post, '_order_status', 'on-hold');
                update_post_meta($post, '_checkout_request_id', $result['CheckoutRequestID']);
                wp_update_post(['post_content' => json_encode($result), 'ID' => $post]);

                $error_message = '<p>Awaiting MPesa confirmation of payment from ' . $phone . ' for request ' . $request_id . '. Check your phone for the STK Prompt.</p>';
                $response = array("status" => 0, "msg" => $error_message);
            }
        } else {
            $error_message = __('Could not connect to Mpesa', 'woocommerce');
            update_post_meta($post, '_order_status', 'failed');
            //$order->update_status('failed', $error_message);
            $response = array("status" => 1, "msg" => $error_message);
        }
        exit(wp_send_json($response));
    }
}

//if(is_wc_endpoint_url( 'order-received' )){
add_action('wp_footer', 'ajax_polling');

//}
function ajax_polling() {
    $url = home_url('?pesaipn&order=');
    $url_stk = home_url('?pesaipn_stk&order=');
    ?>
    <script>
        jQuery("#request_stk").hide();
        jQuery("#missed_stk").hide();
        var checker;
        function polling() {
            checker = setInterval(function () {
                if (
                        document.getElementById("payment_method") !== null &&
                        document.getElementById("payment_method").value !== 'mpesa') {
                    clearInterval(checker);
                }

                jQuery(function ($) {
                    var order = $("#current_order").val();
                    $.get('<?php echo $url; ?>' + order, [], function (data) {
                        if (data.receipt == '' || data.receipt == 'N/A') {
                            if (data.status == 'FAULTY') {
                                $("#mpesa_receipt").html('<div class="alert alert-info">Confirming payment <span>.</span><span>.</span><span>.</span><span>.</span><span>.</span><span>.</span></div>');
                            } else {
                                jQuery("#mpesa_receipt").html('<div class="alert alert-danger">' + data.description + "</div>");
                                //$("#mpesa_receipt").hide();
                                $("#missed_stk").show();
                                $("#request_stk").show();
                            }
                        } else {
                            if ($("#mpesa-receipt-overview").length) {
                            } else {
                                $(".woocommerce-order-overview").append(
                                        '<li id="mpesa-receipt-overview" class="woocommerce-order-overview__payment-method method">Receipt number: <strong>' +
                                        data.receipt +
                                        '</strong></li>');
                            }

                            if ($("#mpesa-receipt-table-row").length) {
                            } else {
                                $(".woocommerce-table--order-details > tfoot")
                                        .find('tr:last-child')
                                        .prev()
                                        .after(
                                                '<tr id="mpesa-receipt-table-row"><th scope="row">Receipt number:</th><td>' +
                                                data.receipt +
                                                '</td></tr>');
                            }

                            $("#mpesa_receipt").html('<div class="alert alert-success">Payment confirmed. Receipt number: <b>' +
                                    data.receipt +
                                    '</b></div>');

                            $("#missed_stk").hide();
                            $("#request_stk").hide();
                            clearInterval(checker);

                            return false;
                        }
                    })
                });
            }, 15000);
        }
        polling();
        jQuery("#request_stk").click(function () {
            clearInterval(checker);
            var order = jQuery("#current_order").val();
            jQuery("#request_stk").append(' <i id="request_stk_spinner" class="fa fa-spinner fa-spin"></i>');
            jQuery("#missed_stk").hide();
            jQuery("#mpesa_receipt").hide();
            jQuery.get('<?php echo $url_stk; ?>' + order, [], function (data) {
                if (data.status == '0') {
                    jQuery("#mpesa_receipt").html('<div class="alert alert-info">' + data.msg + ' <span>.</span><span>.</span><span>.</span><span>.</span><span>.</span><span>.</span></div>');
                } else {
                    jQuery("#mpesa_receipt").html('<div class="alert alert-danger">' + data.msg + "</div>");
                }
                jQuery("#request_stk").hide();
                jQuery("#request_stk_spinner").remove();
                jQuery("#mpesa_receipt").show();
                polling();
            });
        });
    </script><?php
}
